﻿#****************************************************************************************************************************************************
#* This Script is used to create default business units and teams with specific guids for Beneficiary Travel Expenses Project for the
#* Veterans Administration. This script calls Custom CmdLets that must be in the correct location for execution to complete without errors.
#* Script created by : Allen Barge
#* Created On: 12/9/2016
#* Last Modified On: 12/9/2016
#* Version Stamp: 1.0.0.3
#* Sprint 3
#*
#* The CmdLets and this script are property of the Verterans Administration, Microsoft Corporation and Liberty IT Solutions. This script is not
#* Open Source and unathorized use of all or part of any section of this script without explicit written permission from the Veterans Administration,
#* Microsoft Corporation or Liberty IT Solutions is not permitted.
#****************************************************************************************************************************************************
#Input parameters not overridden by command line parameters will remain as the default value below
#****************************************************************************************************************************************************
Param(  [String]$TargetUser='username',
        [String]$TargetPassword='password',
        [String]$TargetDomain='libertyitsazure',
        [String]$TargetUri='https://crm.libertybtdev.com/DEV##/',
        [String]$RootBUName='DEV##')

[String]$WorkingFolder = (Get-Item -Path ".\" -Verbose).FullName

Write-Host "Setting default folder execution reference to $WorkingFolder"
Write-Host "Executing script with crm username $TargetUser"
#****************************************************************************************************************************************************
#* Import The Library for Use And set the working folder
#****************************************************************************************************************************************************
Import-Module "$WorkingFolder\Modules\CRM2016CustomCmdLets\CRM2016CustomCmdLets.dll" -Verbose
cd\
cd "$WorkingFolder"
Write-Host "Switching to Working Folder - $WorkingFolder"

#****************************************************************************************************************************************************
#****************************************************************************************************************************************************
#* Start of Create Business Unit Records
#****************************************************************************************************************************************************
#****************************************************************************************************************************************************

[String]$ParentBUName = $RootBUName
#****************************************************************************************************************************************************
#* Create the new Business Unit Record under DEV02
#****************************************************************************************************************************************************
New-CRMBusinessUnitRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -Name "Pacific" -BusinessUnitId "F187561C-473F-48E8-AE8C-B0F8601E8C5D" -ParentName "$ParentBUName" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMBusinessUnitRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -Name "North Atlantic" -BusinessUnitId "96B0C374-5C17-4E8F-880B-F0FCF303433C" -ParentName "$ParentBUName" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMBusinessUnitRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -Name "Continental" -BusinessUnitId "98395C5F-2E08-46EB-A3EB-1C39B98D72AA" -ParentName "$ParentBUName" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMBusinessUnitRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -Name "Midwest" -BusinessUnitId "B3F25260-493D-40E5-89D8-250D20C3B698" -ParentName "$ParentBUName" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMBusinessUnitRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -Name "Southeast" -BusinessUnitId "285030ED-C193-4A1C-9EDB-BB54D1A46F11" -ParentName "$ParentBUName" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"

#****************************************************************************************************************************************************
#* Create the new Business Unit Record under North Atlantic
#****************************************************************************************************************************************************
$ParentBUName = 'North Atlantic'
New-CRMBusinessUnitRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -Name "VISN 1 (North Atlantic)" -BusinessUnitId "FC601F4C-B011-4A56-9113-CDA1E32EA7C7" -ParentName "$ParentBUName" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMBusinessUnitRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -Name "VISN 2 (North Atlantic)" -BusinessUnitId "B56BE1AD-1657-4B49-8775-5AB420E9165A" -ParentName "$ParentBUName" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMBusinessUnitRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -Name "VISN 3 (North Atlantic)" -BusinessUnitId "0F86D4E4-929C-46B4-BCD0-03102EAA2349" -ParentName "$ParentBUName" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMBusinessUnitRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -Name "VISN 4 (North Atlantic)" -BusinessUnitId "FEFE0C2F-47F4-49A2-ADCA-9E96121FF1E4" -ParentName "$ParentBUName" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMBusinessUnitRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -Name "VISN 5 (North Atlantic)" -BusinessUnitId "8C71FBD3-54C7-4DE5-BAC7-51EF64745813" -ParentName "$ParentBUName" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMBusinessUnitRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -Name "VISN 6 (North Atlantic)" -BusinessUnitId "0C6B18FD-C95C-4C77-B59A-E8413B511273" -ParentName "$ParentBUName" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"

#****************************************************************************************************************************************************
#* Create the new Business Unit Record under Southeast
#****************************************************************************************************************************************************
$ParentBUName = 'Southeast'
New-CRMBusinessUnitRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -Name "VISN 7 (Southeast)" -BusinessUnitId "DA0D7FBB-3B50-4006-BFB0-4ABD6CA388BF" -ParentName "$ParentBUName" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMBusinessUnitRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -Name "VISN 8 (Southeast)" -BusinessUnitId "4EED2DE3-4576-48CC-982E-2DB0A9174F48" -ParentName "$ParentBUName" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMBusinessUnitRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -Name "VISN 9 (Southeast)" -BusinessUnitId "568A81F4-53B9-45F6-9A3A-F44DAF3F8BEC" -ParentName "$ParentBUName" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"

#****************************************************************************************************************************************************
#* Create the new Business Unit Record under Midwest
#****************************************************************************************************************************************************
$ParentBUName = 'Midwest'
New-CRMBusinessUnitRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -Name "VISN 10 (Midwest)" -BusinessUnitId "77F522F3-37B1-49C3-9456-079BDA927046" -ParentName "$ParentBUName" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMBusinessUnitRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -Name "VISN 11 (Midwest)" -BusinessUnitId "D7543213-99BC-416F-832C-5F6F0AD33FDA" -ParentName "$ParentBUName" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMBusinessUnitRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -Name "VISN 12 (Midwest)" -BusinessUnitId "5CB35ED1-CBDC-467E-9A8E-A80467814086" -ParentName "$ParentBUName" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMBusinessUnitRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -Name "VISN 15 (Midwest)" -BusinessUnitId "BB2AB58C-C09C-4C5A-876D-A77237C5F79A" -ParentName "$ParentBUName" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMBusinessUnitRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -Name "VISN 23 (Midwest)" -BusinessUnitId "AC2736C3-F638-49B2-9410-0D511B84993A" -ParentName "$ParentBUName" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"

#****************************************************************************************************************************************************
#* Create the new Business Unit Record under Continental
#****************************************************************************************************************************************************
$ParentBUName = 'Continental'
New-CRMBusinessUnitRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -Name "VISN 16 (Continental)" -BusinessUnitId "F2DCB970-30F9-4E86-A8B6-756271CFDCBB" -ParentName "$ParentBUName" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMBusinessUnitRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -Name "VISN 17 (Continental)" -BusinessUnitId "6BE49698-F598-4EA3-80D5-5BC5B5A0024D" -ParentName "$ParentBUName" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMBusinessUnitRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -Name "VISN 19 (Continental)" -BusinessUnitId "CDC06020-67DB-445C-A0FD-11677498698E" -ParentName "$ParentBUName" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"

#****************************************************************************************************************************************************
#* Create the new Business Unit Record under Pacific
#****************************************************************************************************************************************************
$ParentBUName = 'Pacific'
New-CRMBusinessUnitRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -Name "VISN 18 (Pacific)" -BusinessUnitId "CF63FCBC-4130-4EEC-AD10-0432E76C4415" -ParentName "$ParentBUName" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMBusinessUnitRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -Name "VISN 20 (Pacific)" -BusinessUnitId "4D558865-0D00-4A42-B8A1-4EC5D7526147" -ParentName "$ParentBUName" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMBusinessUnitRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -Name "VISN 21 (Pacific)" -BusinessUnitId "E898F9A6-B2F7-460A-B4F5-6E7B376090D3" -ParentName "$ParentBUName" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMBusinessUnitRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -Name "VISN 22 (Pacific)" -BusinessUnitId "BA6D75CA-D821-4B87-B0D0-2DC34C71232D" -ParentName "$ParentBUName" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"

#****************************************************************************************************************************************************
#****************************************************************************************************************************************************
#* Start of Create Team Records
#****************************************************************************************************************************************************
#****************************************************************************************************************************************************

#****************************************************************************************************************************************************
#* VISN 1 (North Atlantic)
#****************************************************************************************************************************************************
[String]$ParentBUName = "VISN 1 (North Atlantic)"
[String]$ParentBUId = "FC601F4C-B011-4A56-9113-CDA1E32EA7C7"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA Maine Healthcare Systems (Togus)" -TeamId "033A875C-5B10-4209-9204-79707ACB491A" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "White River Junction VA Medical Center" -TeamId "C64F6BAF-A70D-43ED-A84C-D243ACB566FC" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Edith Nourse Rogers Memorial Veterans Hospital (Bedford VA)" -TeamId "CF9B1666-3957-4578-8252-B75CE8DC14E1" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA Boston Health Care System (Jamaica Plain, Brockton, West Roxbury)" -TeamId "34CC01EF-C7B0-4E9B-8B86-37EED1339361" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Manchester VA Medical Center" -TeamId "D6CC38C3-3C75-43EB-9EF2-DC96386EEFB5" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA Central Western Massachusetts Healthcare System (Formerly Northampton VA Medical Center)" -TeamId "6946D7A3-6CA3-4026-B892-1564FE9E2824" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Providence VA Medical Center" -TeamId "EB182731-5168-4FC9-86D3-069E8E43B6F3" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA Connecticut Health Care System (West Haven, Newington)" -TeamId "40746356-A57C-459E-925C-4A6D9B373324" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"

#****************************************************************************************************************************************************
#* VISN 2 (North Atlantic)
#****************************************************************************************************************************************************
$ParentBUName = "VISN 2 (North Atlantic)"
$ParentBUId = "B56BE1AD-1657-4B49-8775-5AB420E9165A"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA Western New York Healthcare System (Buffalo and Batavia)" -TeamId "D8E2A1A1-D1BE-4409-93CD-02FC7AF51E29" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Canandaigua VA Medical Center" -TeamId "B7AF6448-E7B1-46EE-A294-9383DCCE3FF0" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Bath VA Medical Center" -TeamId "97302271-B0E1-4CFA-B2BF-08C33C194367" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Syracuse VA Medical Center" -TeamId "F3C1E701-9BFD-4219-AE82-CE5265CBB490" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Albany VA Medical Center (Samuel S. Stratton)" -TeamId "E84988EF-50DC-4774-AD2C-F9DB186117CA" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Upstate New York Health Care System (Buffalo, Batavia, Canandaigua, Syracuse, Bath, Albany)" -TeamId "B162CDA7-8BCE-4D0E-9865-9D4301EC8AFE" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"

#****************************************************************************************************************************************************
#* VISN 3 (North Atlantic)
#****************************************************************************************************************************************************
$ParentBUName = "VISN 3 (North Atlantic)"
$ParentBUId = "0F86D4E4-929C-46B4-BCD0-03102EAA2349"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "James J. Peters VA Medical Center (Bronx, NY)" -TeamId "43CE2FF7-42F0-4674-907B-C34F3E9F81A2" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA New Jersey Health Care System (East Orange, Lyons)" -TeamId "6DED6960-41F2-49F2-911A-9FEA279D6F58" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA Hudson Valley Health Care System (Montrose, Castle Point)" -TeamId "83B8A943-FFF0-48B6-A755-C877B86134DB" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA New York Harbor Health Care System (Brooklyn, Manhattan)" -TeamId "23E976C6-93C3-46F5-99BF-371FC1E8733F" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Northport VA Medical Center" -TeamId "E30BE485-FF74-4893-A773-AD21BCB671D9" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"

#****************************************************************************************************************************************************
#* VISN 4 (North Atlantic)
#****************************************************************************************************************************************************
$ParentBUName = "VISN 4 (North Atlantic)"
$ParentBUId = "FEFE0C2F-47F4-49A2-ADCA-9E96121FF1E4"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Wilmington VA Medical Center" -TeamId "0AFD0F74-33D6-47EF-882A-6172567C965C" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Altoona - James E. Van Zandt VA Medical Center" -TeamId "B73225C5-7090-4337-B0DD-3721BDC7FBCC" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA Butler Healthcare" -TeamId "E0D0E947-B64E-4046-A719-DAF6F48B439A" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Coatesville VA Medical Center" -TeamId "93DD9772-82C1-436C-B297-47CBAE0C2C75" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Erie VA Medical Center" -TeamId "33E53A0D-9483-483F-A333-AFD4CFF91178" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Lebanon VA Medical Center" -TeamId "0EE67BEF-CBF4-43E5-AAC3-9404D45E5FC9" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Philadelphia VA Medical Center" -TeamId "A541398C-8864-4794-9FEE-E34E60F59D58" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA Pittsburgh Health Care System (Pittsburgh University Dr., H. J. Heinz Campus)" -TeamId "55E02D1C-9C1E-411E-A33E-4505155E107F" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Wilkes-Barre VA Medical Center" -TeamId "A7AAFBA8-F68E-4DEE-98E2-ED815ABE6C0C" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"

#****************************************************************************************************************************************************
#* VISN 5 (North Atlantic)
#****************************************************************************************************************************************************
$ParentBUName = "VISN 5 (North Atlantic)"
$ParentBUId = "8C71FBD3-54C7-4DE5-BAC7-51EF64745813"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA Maryland Health Care System (Baltimore, Loch Raven, Perry Point)" -TeamId "8558BC1D-B424-4B7B-AC55-062D8265D2EC" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Beckley VA Medical Center" -TeamId "77C5F051-AE33-413C-8E83-03864F7A42AF" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Louis A. Johnson VA Medical Center (Clarksburg)" -TeamId "663F9993-F435-47EE-82E8-CA0A44248A93" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Huntington VA Medical Center" -TeamId "B8159F04-A9A2-4CDB-992F-6B174AF87706" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Martinsburg VA Medical Center" -TeamId "3F063902-5FC8-4A4C-99A1-75F80A2107BD" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Washington DC VA Medical Center" -TeamId "0223C147-E05E-4E12-AAD9-8470F2C04E65" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"

#****************************************************************************************************************************************************
#* VISN 6 (North Atlantic)
#****************************************************************************************************************************************************
$ParentBUName = "VISN 6 (North Atlantic)"
$ParentBUId = "0C6B18FD-C95C-4C77-B59A-E8413B511273"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Durham VA Medical Center" -TeamId "21FE9623-E0C5-4CFE-B73F-1256B5209818" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Fayetteville VA Medical Center" -TeamId "8A7E9C4F-237E-4413-A17B-506996D403F8" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Hampton VA Medical Center" -TeamId "3426B3F0-9AC2-41DF-A08B-DD8CEB3D176F" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Asheville VA Medical Center" -TeamId "A15A104B-6FF0-4E06-98E7-99948D69FA25" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Hunter Holmes McGuire VA Medical Center (Richmond)" -TeamId "64357A32-B56B-47A6-8675-7961CDDB4DC4" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Salem VA Medical Center" -TeamId "2F7CCB10-00B3-425C-B547-1FBE3BA5398C" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "W.G. (Bill) Hefner VA Medical Center (Salisbury)" -TeamId "3BECB8E9-A8B7-4090-986B-4479377A918D" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"

#****************************************************************************************************************************************************
#* VISN 7 (Southeast)
#****************************************************************************************************************************************************
$ParentBUName = "VISN 7 (Southeast)"
$ParentBUId = "DA0D7FBB-3B50-4006-BFB0-4ABD6CA388BF"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Atlanta VA Health Care System" -TeamId "D8F11A5A-61FE-4814-9C2B-F3529905F22B" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Charlie Norwood VA Medical Center (Augusta)" -TeamId "1477E306-AFBC-456B-8C00-EED18D354F5B" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Birmingham VA Medical Center" -TeamId "99B721B7-870E-4DDA-BB96-257BFC86709A" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Ralph H. Johnson VA Medical Center (Charleston)" -TeamId "1421447A-CB72-45C3-9D2F-585C7C44B572" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Wm. Jennings Bryan Dorn VA Medical Center (Columbia)" -TeamId "43A9BA97-10EB-49BA-8BE9-A79D985281D0" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Carl Vinson VA Medical Center  (Dublin)" -TeamId "565039FC-50C5-4FB1-BF74-897B0817084A" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Central Alabama Veterans Health Care System (Tuskegee, Montgomery)" -TeamId "498B3330-DF28-4729-AC7F-58C288BD8E5F" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Tuscaloosa VA Medical Center" -TeamId "4F32034E-7276-4DCB-9DF3-AFF1CFA8207B" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"

#****************************************************************************************************************************************************
#* VISN 8 (Southeast)
#****************************************************************************************************************************************************
$ParentBUName = "VISN 8 (Southeast)"
$ParentBUId = "4EED2DE3-4576-48CC-982E-2DB0A9174F48"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "C.W. Bill Young VA Medical Center (Bay Pines)" -TeamId "AD99E333-4905-46CD-9477-8315717B2A47" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Miami VA Healthcare System" -TeamId "EAC4CD09-5B99-456C-AA62-0C0C3233B743" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "West Palm Beach VA Medical Center" -TeamId "DFA84B1B-0867-4CF5-9ECA-59EB8D05353F" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA North Florida / South Georgia VA Health Care System  (Gainesville, Lake City)" -TeamId "6036511A-5CF1-4974-9215-AA51FB91EE6E" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA Caribbean Healthcare System (San Juan)" -TeamId "CAFD824F-9523-495D-9635-D7F0C87178DE" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "James A. Haley Veterans' Hospital (Tampa)" -TeamId "B459A8B0-8DAD-4E65-B333-7E01865C4F0A" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Orlando VA Medical Center" -TeamId "77109EA1-330D-4348-8F15-E8F82D13287F" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"

#****************************************************************************************************************************************************
#* VISN 9 (Southeast)
#****************************************************************************************************************************************************
$ParentBUName = "VISN 9 (Southeast)"
$ParentBUId = "568A81F4-53B9-45F6-9A3A-F44DAF3F8BEC"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Lexington VA Medical Center (Leestown, Cooper)" -TeamId "A6BBBA92-713D-40E6-AF91-545DA60816BB" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Robley Rex VA Medical Center (Louisville)" -TeamId "F7F501B5-CA4F-4DE1-BFB1-BF8C64433659" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Memphis VA Medical Center" -TeamId "ABC0C624-C279-4AEB-886D-50925CFEE5DF" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "James H. Quillen VA Medical Center (Mountain Home)" -TeamId "7FA0F660-916C-4776-A272-DCF321F22B38" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA Tennessee Valley Health Care System (Nashville, Murfreesboro)" -TeamId "A6600399-D427-4EB3-A3AB-2DBD2DDE5629" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"

#****************************************************************************************************************************************************
#* VISN 10 (Midwest)
#****************************************************************************************************************************************************
$ParentBUName = "VISN 10 (Midwest)"
$ParentBUId = "77F522F3-37B1-49C3-9456-079BDA927046"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Chillicothe VA Medical Center" -TeamId "2E7C72A3-CD5E-4307-981F-A0A3ECC17825" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Cincinnati VA Medical Center" -TeamId "5070C892-7720-4AFC-A984-982282495F5B" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Louis Stokes Cleveland VA Medical Center" -TeamId "32028A4F-7122-473B-8872-D26EF758B123" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Dayton VA Medical Center" -TeamId "EBCEC36C-FF64-4AA2-837D-EC164FFB9C1C" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Chalmers P. Wylie VA Ambulatory Care Center (Columbus)" -TeamId "4F077CF7-DADA-432D-B3FD-44DB7653CA59" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"

#****************************************************************************************************************************************************
#* VISN 11 (Midwest)
#****************************************************************************************************************************************************
$ParentBUName = "VISN 11 (Midwest)"
$ParentBUId = "D7543213-99BC-416F-832C-5F6F0AD33FDA"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA Ann Arbor Healthcare System" -TeamId "16A1CE8D-9B0F-4CD4-84D0-6C9C3F030877" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Battle Creek VA Medical Center" -TeamId "99ABF8D1-4CF0-450D-8F77-392C8244A09C" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA Illiana Health Care System  (Danville)" -TeamId "F06929E6-A1B5-41A9-948B-3A9F8CE69149" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "John D. Dingell VA Medical Center (Detroit)" -TeamId "2E67F7E6-FA1E-44A5-ADD4-211C5B0B882B" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Richard L. Roudebush VA Medical Center (Indianapolis)" -TeamId "B9260BBD-FFA1-4D47-B312-385410FF01CA" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA Northern Indiana Health Care System (Marion, Fort Wayne)" -TeamId "E8974BAC-D1B9-47C7-A65C-C73516C34273" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Aleda E. Lutz VA Medical Center (Saginaw)" -TeamId "DF345411-3E3C-4486-9C6B-9B11EA442D0C" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"

#****************************************************************************************************************************************************
#* VISN 12 (Midwest)
#****************************************************************************************************************************************************
$ParentBUName = "VISN 12 (Midwest)"
$ParentBUId = "5CB35ED1-CBDC-467E-9A8E-A80467814086"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Jesse Brown VA Medical Center (Chicago Westside, Chicago Lakeside)" -TeamId "064F8053-8203-4167-AED5-4773F20C3F8B" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Captain James A. Lovell Federal Health Care Center (North Chicago)" -TeamId "876B083B-D25E-4B75-8900-ABA93C0013BC" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Edward Hines Jr. VA Hospital (Hines)" -TeamId "284A90EA-51D5-4EE4-B755-35FFD0193A3E" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Oscar G. Johnson VA Medical Center (Iron Mountain)" -TeamId "46F2A46D-911E-4EBC-AC39-E61E2211C6F2" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "William S. Middleton Memorial Veterans Hospital (Madison)" -TeamId "5C73E03A-104A-437E-870E-419160AFAC4D" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Tomah VA Medical Center" -TeamId "8AFB1412-2A06-4B63-9099-10919631215B" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Clement J. Zablocki Veterans Affairs Medical Center (Milwaukee)" -TeamId "AEB886B0-E371-43AB-B8F9-FEE2ABBE27C8" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"

#****************************************************************************************************************************************************
#* VISN 15 (Midwest)
#****************************************************************************************************************************************************
$ParentBUName = "VISN 15 (Midwest)"
$ParentBUId = "BB2AB58C-C09C-4C5A-876D-A77237C5F79A"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA Eastern Kansas Health Care System (Kansas City, Columbia, Topeka, Leavenworth, Wichita) (formerly VA Heartland - West)" -TeamId "7A201E46-4185-4428-A9EE-1E8E0AEF0D35" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA St. Louis Health Care System (St. Louis, Poplar Bluff, Marion) (formerly VA Heartland East)" -TeamId "A1C9E907-57F4-4AF8-A1EC-A40801868DAD" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Columbia VA Medical Center" -TeamId "72D04CFC-C64D-4123-B982-7782610E5F0A" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "East Kansas Health Care System" -TeamId "08954257-BD84-4334-9555-622AA5820AA1" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Wichita Medical Center" -TeamId "9E78BAF8-004A-4162-80B1-E6509F307124" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "John J. Pershing VA Medical Center (Popular Bluff)" -TeamId "04B26B0C-F82F-4E66-B598-675043AA48B5" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Marion Medical Center" -TeamId "4AFC8187-CCB1-4F2F-A683-1B945FB305C5" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"

#****************************************************************************************************************************************************
#* VISN 23 (Midwest)
#****************************************************************************************************************************************************
$ParentBUName = "VISN 23 (Midwest)"
$ParentBUId = "AC2736C3-F638-49B2-9410-0D511B84993A"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Fargo VA Medical Center" -TeamId "F9AD9A96-4F27-46C5-9082-D642F27A8455" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Royal C. Johnson Veterans Memorial Medical Center (Sioux Falls)" -TeamId "CC71CFFD-5468-47A9-87B1-CFCB42138481" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA Black Hills Health Care System (Fort Meade, Hot Springs)" -TeamId "2638A44A-FE3E-492F-964F-3B5EC8BB1CA1" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Minneapolis VA Medical Center" -TeamId "51DBBD5B-4089-451C-8353-EB6437DDB9A9" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA Nebraska-Western Iowa Health Care System (Omaha, Lincoln, Grand Island of NE, Des Moines, Knoxville, Iowa City IA) aka VA Central Plains Health Care System" -TeamId "1300ACCC-7A85-46E2-8D1C-F01ECA53EEBB" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "St. Cloud VA Health Care System" -TeamId "29FDEFEE-83D9-4A33-92C5-48939D212ACE" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA Central Iowa Health Care System (Des Moines)" -TeamId "BB46AF97-2237-4B1D-98F0-D6BC517CD9BF" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Iowa City VA Health Care System" -TeamId "44DA742A-252A-4617-A5C4-08F9887B2942" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"

#****************************************************************************************************************************************************
#* VISN 16 (Continental)
#****************************************************************************************************************************************************
$ParentBUName = "VISN 16 (Continental)"
$ParentBUId = "F2DCB970-30F9-4E86-A8B6-756271CFDCBB"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Alexandria VA Health Care System (Pineville)" -TeamId "A438B47A-47BD-4AFE-922A-B1AE7F9D9952" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Gulf Coast Veterans Health Care System (Biloxi)" -TeamId "3FF84F03-FC1C-42D3-AB7E-0EF79DC8F1BF" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Veterans Health Care System of the Ozarks (Fayetteville)" -TeamId "EAD8DF10-3931-4473-A88D-0F61E77D9FF3" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Michael E. DeBakey VA Medical Center (Houston)" -TeamId "77A7C1F8-283E-4C18-872B-32245FE1AF0F" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "G.V. (Sonny) Montgomery VA Medical Center (Jackson)" -TeamId "76EE24BE-7AC5-4628-92CA-A440300CBC04" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Central Arkansas Veterans Healthcare System (North Little Rock, Little Rock)" -TeamId "9D7F8AC7-5F8D-45B1-B04D-97321938F2A4" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Southeast Louisiana Veterans Health Care System (New Orleans)" -TeamId "1B97D0EF-C0E8-4FE0-8983-C684AE31219B" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Overton Brooks VA Medical Center (Shreveport)" -TeamId "09F9B56F-B8F1-417E-960E-CC0CDC5912D4" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"

#****************************************************************************************************************************************************
#* VISN 17 (Continental)
#****************************************************************************************************************************************************
$ParentBUName = "VISN 17 (Continental)"
$ParentBUId = "6BE49698-F598-4EA3-80D5-5BC5B5A0024D"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Amarillo VA Health Care System" -TeamId "F1213A1A-14B1-4775-B990-39C6E0403AF1" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "West Texas VA Health Care System (Big Spring)" -TeamId "35C5C359-DCCA-4054-9812-A9810284943A" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA North Texas Health Care System (Dallas, Bonham)" -TeamId "94B74DF1-F575-4FFB-9F26-01977C95EE62" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "South Texas Veterans Health Care System (San Antonio, Kerrville)" -TeamId "1DD0A41E-069C-47C4-AACB-135A2A32CD55" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Central Texas Veterans Health Care System (Temple, Waco)" -TeamId "E7ECD7C0-A6DA-4B1E-945B-3B2EEFBD7A01" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA Health Care Center at Harlingen" -TeamId "19BA96F2-763B-4FCF-B559-BB74B72052BF" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA Texas Valley Coastal Bend Health Care System" -TeamId "CA77A926-06A9-448B-BBA7-FA43DC69C71C" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "El Paso VA Health Care System" -TeamId "1C8FB46A-7892-47F9-A046-3CD7C33D6B8C" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"

#****************************************************************************************************************************************************
#* VISN 19 (Continental)
#****************************************************************************************************************************************************
$ParentBUName = "VISN 19 (Continental)"
$ParentBUId = "CDC06020-67DB-445C-A0FD-11677498698E"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA Montana Health Care System (Ft. Harrison, Miles City)" -TeamId "E9CCF223-8660-4618-B3AE-888D0B8EA910" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Cheyenne VA Medical Center" -TeamId "59686E41-5A10-469C-92AC-634591FC0AA4" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA Eastern Colorado Health Care System (ECHCS) (Denver, Fort Lyon)" -TeamId "819924F9-FBDE-42C3-AA07-3BC5D3AD6C09" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Grand Junction VA Medical Center" -TeamId "8AD7DB64-8794-4C1B-B80E-9C6A78464C7F" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Jack C. Montgomery VA Medical Center (Muskogee)" -TeamId "0F4835CC-B205-4561-AA9D-DE255E1529FB" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Oklahoma City VA Medical Center" -TeamId "9A804D92-4A01-417C-A422-E38D6A3A6613" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA Salt Lake City Health Care System" -TeamId "B1DFBA84-869A-4EAD-8C2B-C86E367D9557" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Sheridan VA Medical Center" -TeamId "6AF7F174-834B-4EA5-8183-DF4875F4E475" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"

#****************************************************************************************************************************************************
#* VISN 18 (Pacific)
#****************************************************************************************************************************************************
$ParentBUName = "VISN 18 (Pacific)"
$ParentBUId = "CF63FCBC-4130-4EEC-AD10-0432E76C4415"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "New Mexico VA Health Care System (Albuquerque)" -TeamId "0041CDB3-78FD-45D1-BF30-1197C8DD05CA" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Phoenix VA Health Care System" -TeamId "BFCFEB72-E2C2-4370-B197-EC72C7B46116" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Northern Arizona VA Health Care System (Prescott)" -TeamId "2CBB61A1-989C-4EE4-92FF-B360E4EEF011" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Southern Arizona VA Health Care System (Tucson)" -TeamId "F318A3EF-53B1-4EF5-AE0C-9AA913DB7399" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"

#****************************************************************************************************************************************************
#* VISN 20 (Pacific)
#****************************************************************************************************************************************************
$ParentBUName = "VISN 20 (Pacific)"
$ParentBUId = "4D558865-0D00-4A42-B8A1-4EC5D7526147"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Alaska VA Healthcare System (Anchorage)" -TeamId "FCFBF592-D800-474A-B90E-2E2000C230C5" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Boise VA Medical Center" -TeamId "EE6370CE-A7FB-472F-B50A-9DDD50920061" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA Portland Health Care System (Portland, Vancouver) " -TeamId "5DFFB080-D6B8-428F-8E67-90CB356ADA2A" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA Roseburg Healthcare System" -TeamId "AB020E81-047B-4745-975A-9C36F904C42D" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA Puget Sound Health Care System (Seattle, American Lake)" -TeamId "E31C6568-2DC6-4869-BF8D-07EC35D11A36" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Mann-Grandstaff VA Medical Center (Spokane)" -TeamId "17716798-C632-4F67-B039-B42B755CDFC2" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Jonathan M. Wainwright Memorial VA Medical Center (Walla Walla)" -TeamId "7A99D35B-6F67-4696-AD2B-70BB4178BB7D" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA Southern Oregon Rehabilitation Center & Clinics (White City)" -TeamId "A5B74C7A-38E1-4B67-9FAF-79E9CFDFD0C5" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"

#****************************************************************************************************************************************************
#* VISN 21 (Pacific)
#****************************************************************************************************************************************************
$ParentBUName = "VISN 21 (Pacific)"
$ParentBUId = "E898F9A6-B2F7-460A-B4F5-6E7B376090D3"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Manila Outpatient Clinic (Philippines)" -TeamId "22C76E57-8F65-4F38-AF8F-FD686B2962B4" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA Pacific Islands Health Care System (Honolulu)" -TeamId "1EAC3C01-DCBB-43C0-8C0F-3EBA490BE30C" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Central California VA Health Care System (Fresno)" -TeamId "5EB190B0-C080-440E-A21F-F3F077E6D25B" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA Southern Nevada Healthcare System (Las Vegas)" -TeamId "25D08445-1A38-413C-806C-000A480D777D" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA Northern California Health Care System (Mather)" -TeamId "C3A33DC1-CEA6-4A4B-9080-46B281FAD554" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA Palo Alto Health Care System (Menlo Park, Palo Alto, Livermore)" -TeamId "B15893F8-F562-420F-93AC-74B6830407DC" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA Sierra Nevada Health Care System (Reno)" -TeamId "3B7C8E86-2164-4ABC-9389-1778DF1E8415" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "San Francisco VA Medical Center" -TeamId "107C169D-07F1-4936-9102-898275182A8D" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"

#****************************************************************************************************************************************************
#* VISN 22 (Pacific)
#****************************************************************************************************************************************************
$ParentBUName = "VISN 22 (Pacific)"
$ParentBUId = "BA6D75CA-D821-4B87-B0D0-2DC34C71232D"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA Long Beach Heathcare System" -TeamId "07A6C1CA-6A34-4E33-BC75-09ED6F7E1EDC" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "Jerry L. Pettis Memorial VA Medical Center (Loma Linda)" -TeamId "89C15B75-2A4D-48A1-BAC9-152EDE7474B7" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA San Diego Healthcare System" -TeamId "4C3827B4-5C6C-4B27-BB83-A1492A043449" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
New-CRMTeamRecord -OrganizationUri "$TargetUri/XRMServices/2011/Organization.svc" -TeamName "VA Greater Los Angeles Healthcare System (Los Angeles, West Los Angeles)" -TeamId "54D9CBC4-6858-49BF-850E-D6BB2FDA1DE2" -ParentBUName "$ParentBUName" -ParentBUId "$ParentBUId" -Username "$TargetUser" -Password "$TargetPassword" -Domain "$TargetDomain"
